﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">


	private MyParams myParams;


	[Context]
	public MyParams Prms
	{ set { myParams = value; } }


	public class MyParams : ContextBase
	{
		private Boolean zaznaczone;
		private IPodmiotKasowy podmiot;
		private FromTo okres;
		private Boolean bufor;


		[Priority(10)]
		[Caption("Wg listy")]
		public Boolean Zaznaczone
		{
			get { return zaznaczone; }
			set
			{
				zaznaczone = value;
				OnChanged(EventArgs.Empty);
			}
		}

		
		[Priority(20)]
		[DefaultWidth(25)]
		public IPodmiotKasowy Podmiot
		{
			get { return podmiot; }
			set { podmiot = value; }
		}


		[Priority(30)]
		[DefaultWidth(25)]
		public FromTo Okres
		{
			get { return okres; }
			set
			{
				okres = adjustOkres(value);
				OnChanged(EventArgs.Empty);
			}
		}


		[Priority(40)]
		public Boolean Bufor
		{
			get { return bufor; }
			set { bufor = value; }
		}


		[Browsable(false)]
		public String BuforStr
		{ get { return bufor ? "TAK" : "NIE"; } }

		[Browsable(false)]
		public String PodmiotStr
		{ get { return podmiot!=null ? podmiot.Nazwa : "(wszyscy)"; } }


		public Boolean IsReadOnlyBufor()
		{ return zaznaczone; }

		public Boolean IsReadOnlyPodmiot()
		{ return zaznaczone; }

		public Boolean IsReadOnlyOkres()
		{ return zaznaczone; }

		
		public MyParams(Context ctx) :
			base(ctx)
		{
			ctx[GetType()] = this;
			
			PodmiotParams pp = (PodmiotParams)ctx[typeof(PodmiotParams)];

			this.podmiot = pp.Podmiot;
			this.okres = adjustOkres(pp.Okres);
			this.bufor = false;
			this.zaznaczone = true;
		}


		private FromTo adjustOkres(FromTo okres)
		{ return okres == FromTo.Empty ? FromTo.All : okres; }
	}

	
	protected void dc_ContextLoad(object sender, EventArgs e)
	{
		if (!myParams.Zaznaczone)
		{
			Soneta.Business.View view = KasaModule.GetInstance(dc).DokRozliczeniowe.WgTypData[TypDokumentu.NotaKorygujaca].CreateView();

			if (myParams.Podmiot != null)
				view.Condition &= new FieldCondition.Equal("Podmiot", myParams.Podmiot);
			if (myParams.Okres != FromTo.All)
				view.Condition &= new FieldCondition.Contain("Data", myParams.Okres);
			if (!myParams.Bufor)
				view.Condition &= new FieldCondition.Equal("Bufor", false);

			ReportHeader01["PODMIOT"] = myParams.PodmiotStr;
			ReportHeader01["BUFOR"] = myParams.BuforStr;
			ReportHeader01["OKRES"] = myParams.Okres.ToString();

			Grid01.DataSource = view;
		}
		else
		{
			ReportHeader01.Title = "Zestawienie Not Korygujących|(wg listy)";
		}
	}
	
	
</script>
<html>
<head>
	<title>Zestawienie Not Korygujących</title>
</head>
<body>
	<ea:DataContext ID="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
	<eb:ReportHeader ID="ReportHeader01" runat="server" Title="Zestawienie Not Korygujących|Podmiot: %PODMIOT%|Okres: %OKRES%|Bufor: %BUFOR%" />

	<ea:Grid ID="Grid01" runat="server" RowTypeName="Soneta.Kasa.NotaKorygujaca,Soneta.Kasa">
		<Columns>
			<ea:GridColumn runat="server" Align="Center" DataMember="#" Caption="LP." Width="5" />
			<ea:GridColumn runat="server" Align="Center" DataMember="Data" Caption="Data" Width="12" />
			<ea:GridColumn runat="server" Align="Left" DataMember="Podmiot.Nazwa" EncodeHTML="true" Width="28" Caption="Podmiot" />
			<ea:GridColumn runat="server" Align="Left" DataMember="Numer" Width="20" EncodeHTML="true" Caption="Numer" />
			<ea:GridColumn runat="server" Align="Left" DataMember="DokumentyKorygowaneStr" EncodeHTML="true" Caption="Korygowane dokumenty" />
		</Columns>
	</ea:Grid>
	<eb:ReportFooter ID="ReportFooter" runat="server" />
</body>
</html>

